!!ARBfp1.0
OPTION ARB_precision_hint_fastest;

PARAM param0 = program.env[0];
PARAM outlineColor = program.env[1];

TEMP texture0;
TEX texture0, fragment.texcoord[0], texture[0], 2D;

TEMP outcolor;
MOV outcolor, 0;

// Outline
TEMP t;
MOV outcolor.xyz, outlineColor;
MAD_SAT outcolor.w, texture0.w, param0.x, param0.z;
MUL outcolor.w, outcolor.w, outlineColor.w;
// LRP outcolor, t.w, outlineColor, outcolor; // Makes a blackish border

// Main body
MAD_SAT t.w, texture0.w, param0.x, param0.y;
LRP outcolor, t.w, fragment.color.primary, outcolor;

MOV result.color, outcolor;

END

#version 140
#pragma glov_param(vertex_shader data/shaders/sprite.vp)
#pragma glov_param(param1 outlineColor)

uniform sampler2D tex0;
uniform vec4 param0;
uniform vec4 outlineColor;

in vec4 interp_color;
in vec2 interp_uvs;
out vec4 result;

void main(void)
{
	float texture0 = texture(tex0, interp_uvs).r;

	// Outline
	vec4 outcolor = vec4(outlineColor.xyz, 0);
	outcolor.w = clamp(texture0 * param0.x + param0.z, 0.0, 1.0);
	outcolor.w = outcolor.w * outlineColor.w;
	// outcolor = mix(outcolor, outlineColor, outcolor.w); // Makes a blackish border

	// Main body
	float t = clamp(texture0 * param0.x + param0.y, 0.0, 1.0);
	result = mix(outcolor, interp_color, t);
}

END
