!!ARBfp1.0
OPTION ARB_precision_hint_fastest;

PARAM param0 = program.env[0];
PARAM uv_trans = program.env[1];

TEMP progress;
MOV progress, param0.xxxx;
SUB progress.y, 1, progress.x;

TEMP texture0;
TEX texture0, fragment.texcoord[0], texture[0], 2D;
TEMP logo_coords;
MAD logo_coords.xy, fragment.texcoord[0], uv_trans.xyyy, uv_trans.zwww;
TEMP logo;
TEX logo, logo_coords, texture[1], 2D;

TEMP alpha;
DP3 alpha.x, logo, 0.33333;
LRP alpha.x, alpha.x, 1, progress.y;
MAD_SAT progress.z, progress.x, 8, -7;
LRP alpha.x, progress.z, 0, alpha.x;
LRP result.color.w, logo.w, alpha.x, 1;
LRP result.color.xyz, logo.w, logo, texture0;

END

#version 140
#pragma glov_param(vertex_shader data/shaders/sprite.vp)
#pragma glov_param(param0 param0)
#pragma glov_param(param1 uv_trans)

uniform sampler2D tex0;
uniform sampler2D tex1;

uniform vec4 param0;
uniform vec4 uv_trans;

in vec4 interp_color;
in vec2 interp_uvs;
out vec4 result;

void main(void)
{
	float progress = param0.x;
	vec4 texture0 = texture(tex0, interp_uvs);
	vec2 logo_coords = interp_uvs * uv_trans.xy + uv_trans.zw;
	vec4 logo = texture(tex1, logo_coords);
	float alpha = mix(1 - progress, 1, dot(logo.xyz, vec3(0.33333, 0.33333, 0.33333))); // alpha of logo
	alpha = mix(alpha, 0, max(0, progress * 8 - 7)); // make logo completely alpha'd out in final 8th
	result.a = mix(1, alpha, logo.w); // non-logo part of overlay always opaque
	result.rgb = mix(texture0.rgb, logo.rgb, logo.w);
}

END
