!!ARBfp1.0
OPTION ARB_precision_hint_fastest;

PARAM param0 = program.env[0];
PARAM param1 = program.env[1];

TEMP temp1;
MAD temp1.xy, fragment.texcoord[0], param0, 0.5;
FLR temp1.xy, temp1.xyyy;
MAD temp1.xy, temp1.xyyy, param0.zwzw, -param1;
MIN temp1.xy, temp1.xyyy, param1.zwzw;

TEMP texture0;
TEX texture0, temp1, texture[0], 2D;

MOV result.color.xyz, texture0;
MOV result.color.w, 1;

END


#version 140
#pragma glov_param(vertex_shader data/shaders/sprite.vp)
#pragma glov_param(param0 param0)
#pragma glov_param(param1 param1)

uniform vec4 param0;
uniform vec4 param1;

uniform sampler2D tex0;

in vec4 interp_color;
in vec2 interp_uvs;
out vec4 result;

void main(void)
{
	// TODO: for best look, should generate an appropriate mipmap and sample from that/just render it w/ nearest neighbor
	// result = texture(tex0, min(floor(interp_uvs.xy * param0.xy + 0.5) * param0.zw - param1.xy, param1.zw) );

	// Unlike ARBfp version, shift RGB channels separately (3x slowdown)
	vec4 texture0r = texture(tex0, min(floor(interp_uvs.xy * param0.xy + vec2(0.58, 0.5)) * param0.zw - param1.xy, param1.zw) );
	vec4 texture0g = texture(tex0, min(floor(interp_uvs.xy * param0.xy + vec2(0.5, 0.48)) * param0.zw - param1.xy, param1.zw) );
	vec4 texture0b = texture(tex0, min(floor(interp_uvs.xy * param0.xy + vec2(0.42, 0.5)) * param0.zw - param1.xy, param1.zw) );
	result = vec4(texture0r.r, texture0g.g, texture0b.b, 1);
}

END
