!!ARBfp1.0
OPTION ARB_precision_hint_fastest;

PARAM param0 = program.env[0];

TEMP texture0;
TEX texture0, fragment.texcoord[0], texture[0], 2D;
TEMP res;
MAD_SAT res.w, texture0.w, param0.x, param0.y;
MUL result.color.w, res.w, fragment.color.primary.w;
MOV result.color.xyz, fragment.color.primary;

END

#version 140
#pragma glov_param(vertex_shader data/shaders/sprite.vp)

uniform sampler2D tex0;
uniform vec4 param0;

in vec4 interp_color;
in vec2 interp_uvs;
out vec4 result;

void main(void)
{
	float texture0 = texture(tex0, interp_uvs).r;
	float res = clamp(texture0 * param0.x + param0.y, 0.0, 1.0);
	result = vec4(interp_color.rgb, interp_color.a * res);
}

END
