!!ARBfp1.0
OPTION ARB_precision_hint_fastest;

PARAM param0 = program.env[0];

TEMP texture0;
TEMP texture1;
TEX texture0, fragment.texcoord[0], texture[0], 2D;
TEX texture1, fragment.texcoord[0], texture[1], 2D;

TEMP value;
DP3 value, texture0, {0.3333333, 0.3333334, 0.3333333, 1.0};
TEMP valueR;
MUL valueR, value, fragment.color.primary;
TEMP valueG;
MUL valueG, value, param0;
LRP value, texture1.g, valueG, texture0;
LRP value, texture1.r, valueR, value;

MOV result.color.xyz, value;

MUL result.color.w, texture0.w, fragment.color.primary.w;

END

#version 140
#pragma glov_param(vertex_shader data/shaders/sprite.vp)

uniform sampler2D tex0;
uniform sampler2D tex1;
uniform vec4 param0;

in vec4 interp_color;
in vec2 interp_uvs;
out vec4 result;

void main(void)
{
	vec4 texture0 = texture(tex0, interp_uvs);
	vec2 texture1 = texture(tex1, interp_uvs).rg;

	// float value = dot(texture0.rgb, vec3(0.3333333, 0.3333334, 0.3333333));
	float value = dot(texture0.rgb, vec3(0.2, 0.5, 0.3)); // perception-based intensity of Base texture; seems to look better than equal
	vec3 valueR = value * interp_color.rgb;
	vec3 valueG = value * param0.rgb;

	#if 1

	vec3 value3 = mix(texture0.rgb, valueG, texture1.g);
	value3 = mix(value3, valueR, texture1.r);

	#else

	// Non-normalized tint_g version - maybe less discontinuities in tintmap, but much less efficient, especially on ARBfp
	float weightR = texture1.r;
	float weightG = min(texture1.g, 1 - weightR);
	float weightBase = (1 - weightR) - weightG;
	weightBase = clamp(weightBase, 0, 1); // really just max(weightBase, 0), but _saturate should be faster?
	vec3 value3 = weightR * valueR + weightG * valueG + weightBase * texture0.rgb;

	#endif

	result = vec4(value3, texture0.a * interp_color.a);
}

END
