!!ARBfp1.0
OPTION ARB_precision_hint_fastest;

TEMP texture0;
TEMP texture1;
TEX texture0, fragment.texcoord[0], texture[0], 2D;
TEX texture1, fragment.texcoord[0], texture[1], 2D;

TEMP value;
DP3 value, texture0, {0.2, 0.5, 0.3, 1.0};
MUL value, value, fragment.color.primary;
LRP result.color.xyz, texture1, value, texture0;
MUL result.color.w, texture0.w, fragment.color.primary.w;

END

#version 140
#pragma glov_param(vertex_shader data/shaders/sprite.vp)

uniform sampler2D tex0;
uniform sampler2D tex1;

in vec4 interp_color;
in vec2 interp_uvs;
out vec4 result;

void main(void)
{
	vec4 texture0 = texture(tex0, interp_uvs);
	vec4 texture1 = texture(tex1, interp_uvs);
	float value = dot(texture0.rgb, vec3(0.2, 0.5, 0.3));
	vec4 value4 = value * interp_color;
	result.rgb = texture1.rgb * value4.rgb + (1.0 - texture1.rgb) * texture0.rgb;
	result.a = texture0.a * interp_color.a;
}

END
