!!ARBfp1.0
OPTION ARB_precision_hint_fastest;

PARAM ambient = program.env[0];
PARAM light_diffuse = program.env[1];
PARAM lightdir_vs = program.env[2];
PARAM texmod0 = program.env[3];
PARAM texmod1 = program.env[4];

ATTRIB normal_vs = fragment.texcoord[1];

TEMP texture0;
TEMP texture1;
TEMP texcoord;
MOV texcoord.x, texmod0.z;
MOV texcoord.y, texmod0.w;
MAD texcoord.xy, fragment.texcoord[0], texmod0, texcoord;
TEX texture0, texcoord, texture[0], 2D;

MOV texcoord.x, texmod1.z;
MOV texcoord.y, texmod1.w;
MAD texcoord.xy, fragment.texcoord[0], texmod1, texcoord;
TEX texture1, texcoord, texture[1], 2D;

MUL texture0, texture0, texture1;

TEMP temp_light_vs;
TEMP temp_light_vals;
TEMP normal;
TEMP outColor;
TEMP albedo;

MOV albedo, texture0;

	# light vector
	MOV temp_light_vs, lightdir_vs;
		# NORMALIZE(temp_light_vs)
		DP3 temp_light_vs.w, temp_light_vs, temp_light_vs;
		RSQ temp_light_vs.w, temp_light_vs.w;
		MUL temp_light_vs.xyz, temp_light_vs, temp_light_vs.w;

	MOV normal, normal_vs;
		# NORMALIZE(normal)
		DP3 normal.w, normal, normal;
		RSQ normal.w, normal.w;
		MUL normal.xyz, normal, normal.w;

	# diffuse value
	DP3_SAT temp_light_vals.x, normal, temp_light_vs;
	
	# somewhere near half-lambertian
	MAD temp_light_vals.x, temp_light_vals.x, 0.75, 0.25;

	# final color
	MAD temp_light_vals.xyz, temp_light_vals.x, light_diffuse, ambient;
	MUL outColor.xyz, temp_light_vals, albedo;

MUL result.color.xyz, fragment.color.primary, outColor;
#MOV result.color.w, albedo.w;
MUL result.color.w, fragment.color.primary.w, albedo.w;
#MOV result.color.rgb, normal;

END


#version 140
#pragma glov_param(vertex_shader data/shaders/normal.vert)

uniform sampler2D tex0;
uniform sampler2D tex1;

#pragma glov_param(param0 ambient)
#pragma glov_param(param1 light_diffuse)
#pragma glov_param(param2 lightdir_vs)
#pragma glov_param(param3 texmod0)
#pragma glov_param(param4 texmod1)

uniform vec4 ambient;
uniform vec4 light_diffuse;
uniform vec4 lightdir_vs;
uniform vec4 texmod0;
uniform vec4 texmod1;

in vec4 interp_color;
in vec2 interp_uvs;
in vec3 interp_normal_vs;
out vec4 result;

void main(void)
{
	vec2 texcoord = interp_uvs * texmod0.xy + texmod0.zw;
	vec4 texture0 = texture(tex0, texcoord);
	texcoord = interp_uvs * texmod1.xy + texmod1.zw;
	vec4 texture1 = texture(tex1, texcoord);
	vec4 albedo = texture0 * texture1;
	
	vec3 normal_vs = normalize(interp_normal_vs);
	float diffuse = max(0, dot(normal_vs, -lightdir_vs.rgb));
	diffuse = diffuse * 0.75 + 0.25;

	vec3 color = diffuse * light_diffuse.rgb + ambient.rgb;
	result.rgb = color * albedo.rgb * interp_color.rgb;
	result.a = interp_color.a * albedo.a;
}

END

!!CONSOLE
#pragma glov_param(pixel_shader dummy_shader)
END
