!!ARBfp1.0
OPTION ARB_precision_hint_fastest;

PARAM param0 = program.env[0];
PARAM outlineColor = program.env[1];
PARAM glowColor = program.env[2];
PARAM glowParams = program.env[3];

TEMP texture0;
TEX texture0, fragment.texcoord[0], texture[0], 2D;

TEMP outcolor;
MOV outcolor, 0;

// Glow
TEMP t, glowCoord;
TEMP textureGlow;
ADD glowCoord, fragment.texcoord[0], glowParams;
TEX textureGlow, glowCoord, texture[0], 2D;
MAD_SAT t.w, textureGlow.w, glowParams.z, glowParams.w;
MOV outcolor.xyz, glowColor;
MUL outcolor.w, t.w, glowColor.w;
//LRP outcolor, t.w, glowColor, outcolor;

// Outline
MAD_SAT t.w, texture0.w, param0.x, param0.z;
MUL t.w, t.w, outlineColor.w;
//LRP outcolor.xyz, outcolor.w, outcolor, outlineColor; // Gets rid of artifacts, but makes the glow the outline color -_-
LRP outcolor, t.w, outlineColor, outcolor;

// Main body
MAD_SAT t.w, texture0.w, param0.x, param0.y;
LRP outcolor, t.w, fragment.color.primary, outcolor;

MOV result.color, outcolor;

END

#version 140
#pragma glov_param(vertex_shader data/shaders/sprite.vp)
#pragma glov_param(param1 outlineColor)
#pragma glov_param(param2 glowColor)
#pragma glov_param(param3 glowParams)

uniform sampler2D tex0;
uniform vec4 param0;
uniform vec4 outlineColor;
uniform vec4 glowColor;
uniform vec4 glowParams;

in vec4 interp_color;
in vec2 interp_uvs;
out vec4 result;

void main(void)
{
	float texture0 = texture(tex0, interp_uvs).r;
	// Glow
	vec2 glowCoord = interp_uvs + glowParams.xy;
	float textureGlow = texture(tex0, glowCoord).r;
	float t = clamp(textureGlow * glowParams.z + glowParams.w, 0.0, 1.0);
	vec4 outcolor = vec4(glowColor.xyz, t * glowColor.w);
	// vec4outclor = t * glowColor.xyz;
	
	// Outline
	t = clamp(texture0 * param0.x + param0.z, 0.0, 1.0);
	t = t * outlineColor.w;
	// outcolor.xyz = mix(outlineColor.xyz, outcolor.xyz, t); // Gets rid of artifacts, but makes the glow the outline color -_-
	outcolor = mix(outcolor, outlineColor, t);

	// Main body
	t = clamp(texture0 * param0.x + param0.y, 0.0, 1.0);
	result = mix(outcolor, interp_color, t);
}

END
